local t = LoadFallbackB();

-- Marker
if GAMESTATE:IsCourseMode() == true then
t[#t+1] = LoadActor("course") .. {
	InitCommand=cmd(visible,GAMESTATE:IsCourseMode(););
	}
end

t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(horizalign,center;x,SCREEN_RIGHT-366;y,SCREEN_CENTER_Y);
	CurrentSongChangedMessageCommand=cmd(playcommand,"Pop");
	PopCommand=cmd(finishtweening;decelerate,0.1;zoom,0.92;smooth,0.2;zoom,1);
	LoadActor("_circle") .. {
		InitCommand=cmd(zoom,0.3);
		OnCommand=cmd(addx,-10;diffusealpha,0;smooth,0.2;diffusealpha,1;addx,10;);
		OffCommand=cmd(sleep,0.3;smooth,0.1;zoom,0.2;smooth,0.2;diffusealpha,0;zoom,0.4);
	};
	LoadActor("_brightcircle") .. {
		InitCommand=cmd(zoom,0.3;diffusealpha,0);
		CurrentSongChangedMessageCommand=cmd(finishtweening;decelerate,0.1;diffusealpha,0.9;smooth,0.2;diffusealpha,0);
	};
	LoadActor("_arrow") .. {
		InitCommand=cmd(zoom,0.3);
		OnCommand=cmd(addx,-10;diffusealpha,0;smooth,0.2;diffusealpha,1;addx,10;);
		OffCommand=cmd(smooth,0.2;diffusealpha,0;addx,4);
	};
};

t[#t+1] = Def.ActorFrame {
		Def.Quad {
			InitCommand=cmd(horizalign,left;x,SCREEN_LEFT+45;zoomto,387,70;y,SCREEN_CENTER_Y+101;visible,not GAMESTATE:IsCourseMode(););
			OnCommand=cmd(diffuse,color("#80DFEA");diffusealpha,0;smooth,0.2;diffusealpha,1);
			OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
		};
};

--- Banner
t[#t+1] = Def.ActorFrame {
	Def.ActorFrame { -- Color
		Def.Quad {
			InitCommand=cmd(zoomto,220,220;x,SCREEN_LEFT+155;y,SCREEN_CENTER_Y-55;visible,not GAMESTATE:IsCourseMode(););
			OnCommand=cmd(diffuse,color("#26C6DA");diffusealpha,0;smooth,0.2;diffusealpha,1);
			OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
		};
	};
};

t[#t+1] = Def.Sprite {
		name="SongJacket";
        InitCommand=cmd(x,SCREEN_LEFT+155;y,SCREEN_CENTER_Y-55); 
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
		OnCommand=cmd(diffusealpha,0;smooth,0.2;diffusealpha,1);
		ChangedCommand=cmd(finishtweening;smooth,0.2;zoomx,0.8);
		TransitionCommand=cmd(finishtweening;zoomx,0.8;diffusealpha,0;decelerate,0.2;zoom,1;diffusealpha,1;);
        CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
        CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"); 
        SetCommand=function(self) 
            local song = GAMESTATE:GetCurrentSong(); 
			if song then
                if song:HasJacket() then
					self:playcommand("Changed")
                    self:Load(song:GetJacketPath())
					self:playcommand("Transition")
					self:scaletoclipped(220,220)
                elseif song:HasBanner() then
					self:playcommand("Changed")
                    self:Load(song:GetBannerPath())
					self:playcommand("Transition")
                    self:scaletoclipped(220,69)
                else
					self:playcommand("Changed")
                    self:Load(THEME:GetPathG("Common fallback", "banner"))
					self:scaletoclipped(220,220)
					self:playcommand("Transition")
                end
			else
				self:diffusealpha(0)
            end
        end;
		};

if GAMESTATE:IsCourseMode() == false then
-- Yes. Preview videos.

t[#t+1] = Def.Quad {
			InitCommand=cmd(zoomto,220,220;x,SCREEN_LEFT+155;y,SCREEN_CENTER_Y-55;diffuse,color("#000000");;);
			OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
			SetCommand=function(self) 
            local song = GAMESTATE:GetCurrentSong(); 
			if song then
            if song:HasPreviewVid() then
				self:diffusealpha(0)
				self:sleep(0.8)
				self:decelerate(0.8)
				self:diffusealpha(0.6)
			else
				self:stoptweening()
				self:decelerate(0.3)
				self:diffusealpha(0)
            end
			end
    end;
};


t[#t+1] = Def.Sprite {
		name="PreviewVideo";
        InitCommand=cmd(scaletoclipped,220,220;x,SCREEN_LEFT+155;y,SCREEN_CENTER_Y-55); 
        CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
        SetCommand=function(self) 
            local song = GAMESTATE:GetCurrentSong(); 
			if song then
            if song:HasPreviewVid() then
				self:diffusealpha(0)
				self:zoomx(1)
				self:Load(song:GetPreviewVidPath())
				self:sleep(0.8)
				self:decelerate(0.5)
				self:diffusealpha(1)
			else
				self:stoptweening()
				self:decelerate(0.3)
				self:zoomx(0)
				self:diffusealpha(0)
            end
			end
        end;
		};
end		
			
--- 1p
t[#t+1] = Def.ActorFrame {
	Def.ActorFrame { -- Color
		-- Actual ones
		Def.Quad {
			InitCommand=cmd(zoomto,160,110;x,SCREEN_LEFT+352;y,SCREEN_CENTER_Y-110;diffuse,PlayerColor(PLAYER_1);visible,not GAMESTATE:IsCourseMode(););
			OnCommand=cmd(addx,-10;diffusealpha,0;smooth,0.2;addx,10;diffusealpha,1;);
			PlayerJoinedMessageCommand=function(self,param)
				if param.Player == PLAYER_1 then
					(cmd(addx,-10;diffusealpha,0;smooth,0.2;addx,10;diffusealpha,1))(self);
				end;
			end;
			OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
		};
		Def.Quad {
			InitCommand=cmd(zoomto,160,110;x,SCREEN_LEFT+352;y,SCREEN_CENTER_Y;diffuse,PlayerColor(PLAYER_2);visible,not GAMESTATE:IsCourseMode(););
			OnCommand=cmd(addx,-10;diffusealpha,0;smooth,0.2;addx,10;diffusealpha,1;);
			PlayerJoinedMessageCommand=function(self,param)
				if param.Player == PLAYER_2 then
					(cmd(addx,-10;diffusealpha,0;smooth,0.2;addx,10;diffusealpha,1))(self);
				end;
			end;
			OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
		};
	};
};

t[#t+1] = Def.ActorFrame {
	Def.ActorFrame { -- Color
		-- Actual ones
		Def.Quad {
			InitCommand=cmd(zoomto,160,4;x,SCREEN_LEFT+352;y,SCREEN_CENTER_Y-110+13;visible,not GAMESTATE:IsCourseMode(););
			OnCommand=cmd(addx,-10;diffusealpha,0;smooth,0.2;addx,10;diffusealpha,1;);
			PlayerJoinedMessageCommand=function(self,param)
				if param.Player == PLAYER_1 then
					(cmd(playcommand,"Set";addx,-10;diffusealpha,0;smooth,0.2;addx,10;diffusealpha,1))(self);
				end;
			end;
			SetCommand=function(self)
			local steps = GAMESTATE:GetCurrentSteps(PLAYER_1)
				if steps then
					local st = steps:GetStepsType();
					local diff = steps:GetDifficulty();
					local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
					local cd = GetCustomDifficulty(st, diff, courseType);
					self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
				else
					self:diffuse(ColorLightTone(PlayerColor(PLAYER_1)));
				end;
			end;
			BeginCommand=cmd(playcommand,"Set");
			CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
			OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
		};
		
		Def.Quad {
			InitCommand=cmd(zoomto,160,4;x,SCREEN_LEFT+352;y,SCREEN_CENTER_Y+13;diffuse,color("#FFFFFF");visible,not GAMESTATE:IsCourseMode(););
			OnCommand=cmd(addx,-10;diffusealpha,0;smooth,0.2;addx,10;diffusealpha,1;);
			PlayerJoinedMessageCommand=function(self,param)
				if param.Player == PLAYER_2 then
					(cmd(playcommand,"Set";addx,-10;diffusealpha,0;smooth,0.2;addx,10;diffusealpha,1))(self);
				end;
			end;
			SetCommand=function(self)
			local steps = GAMESTATE:GetCurrentSteps(PLAYER_2)
				if steps then
					local st = steps:GetStepsType();
					local diff = steps:GetDifficulty();
					local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
					local cd = GetCustomDifficulty(st, diff, courseType);
					self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
					else
					self:diffuse(ColorLightTone(PlayerColor(PLAYER_2)));
				end;
			end;
			BeginCommand=cmd(playcommand,"Set");
			CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
			OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);		};
	};
};


-- Song Title/Genre

t[#t+1] = LoadFont("_arimo Bold 24px") .. { 
		  InitCommand=cmd(x,SCREEN_LEFT+50;y,SCREEN_CENTER_Y+77;horizalign,left;diffuse,color("#212121");zoom,0.5;diffusealpha,0.8;uppercase,true;visible,not GAMESTATE:IsCourseMode();); 
		  OnCommand=cmd(diffusealpha,0;addx,-10;smooth,0.2;addx,10;diffusealpha,0.8;);		  
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          BeginCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
				self:settext("Genre:");
          end;
};

t[#t+1] = LoadFont("_arimo Bold 24px") .. { 
          InitCommand=cmd(x,SCREEN_LEFT+103;y,SCREEN_CENTER_Y+77;maxwidth,384;horizalign,left;diffuse,color("#212121");zoom,0.5;uppercase,true;); 
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
          CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
               local song = GAMESTATE:GetCurrentSong(); 
               if song then
					self:finishtweening();
					self:smooth(0.2);
					self:diffusealpha(0);
					self:addx(10);
                    self:settext(song:GetGenre()); 
                    self:playcommand("Refresh");
					(cmd(stoptweening;addx,-6;diffusealpha,0.0;smooth,0.2;addx,6;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh");
               end 
          end;
};

t[#t+1] = LoadFont("_arimo Bold 24px") .. { 
		  InitCommand=cmd(x,SCREEN_LEFT+50;y,SCREEN_CENTER_Y+95;horizalign,left;diffuse,color("#212121");zoom,0.75;diffusealpha,0.8;uppercase,true;visible,not GAMESTATE:IsCourseMode();); 
		  OnCommand=cmd(diffusealpha,0;addx,-10;smooth,0.2;addx,10;diffusealpha,0.8;);		  
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          BeginCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
				self:settext("Artist:");
          end;
};

t[#t+1] = LoadFont("Common normal") .. { 
          InitCommand=cmd(x,SCREEN_LEFT+126;y,SCREEN_CENTER_Y+95;maxwidth,400;horizalign,left;diffuse,color("#212121");zoom,0.75;uppercase,false;maxwidth,325;); 
		  BeginCommand=cmd(playcommand,"Set"); 
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
          CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
               local song = GAMESTATE:GetCurrentSong(); 
               if song then 
					self:finishtweening();
					self:smooth(0.2);
					self:diffusealpha(0);
					self:addx(10);
                    self:settext(song:GetDisplayArtist()); 
                    self:playcommand("Refresh");
					(cmd(stoptweening;addx,-6;diffusealpha,0.0;smooth,0.2;addx,6;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh"); 
               end 
          end;
};

-- Sort order 

t[#t+1] = LoadFont("_arimo Bold 24px") .. { 
          InitCommand=cmd(x,SCREEN_LEFT+50;y,SCREEN_CENTER_Y+180;maxwidth,SCREEN_WIDTH;horizalign,left;diffuse,color("#212121");zoom,0.75;uppercase,true;visible,not GAMESTATE:IsCourseMode();); 
		  OnCommand=cmd(addx,-10;diffusealpha,0;smooth,0.2;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          BeginCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
				self:settext("Sort:");
          end;
};

t[#t+1] = LoadFont("Common bold") .. { 
          InitCommand=cmd(x,SCREEN_LEFT+114;y,SCREEN_CENTER_Y+180;maxwidth,SCREEN_WIDTH;horizalign,left;diffuse,color("#212121");zoom,0.75;uppercase,true;visible,not GAMESTATE:IsCourseMode();); 
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          SortOrderChangedMessageCommand=cmd(playcommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
               local sortorder = GAMESTATE:GetSortOrder(); 
               if sortorder then
					self:finishtweening();
					self:smooth(0.2);
					self:diffusealpha(0);
					self:addx(6);
                    self:settext(SortOrderToLocalizedString(sortorder)); 
                    self:playcommand("Refresh");
					(cmd(stoptweening;addx,-6;diffusealpha,0.0;smooth,0.2;addx,6;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh");
               end 
          end;
};

-- Difficulty numbers
t[#t+1] = LoadFont("_roboto condensed light 48px") .. { 
          InitCommand=cmd(x,SCREEN_LEFT+426;y,SCREEN_CENTER_Y-135;horizalign,right;); 
		  OnCommand=cmd(diffusealpha,0;addx,-10;smooth,0.2;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set";playcommand,"Transition";); 
		  TransitionCommand=cmd(finishtweening;diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
		  PlayerJoinedMessageCommand=cmd(playcommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self)
			stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP1 ~= nil then
					self:settext(stepsP1:GetMeter())
				else
					self:settext("")
				end
			else
				self:settext("")
			end
          end
};

t[#t+1] = LoadFont("_roboto condensed light 48px") .. { 
          InitCommand=cmd(x,SCREEN_LEFT+426;y,SCREEN_CENTER_Y-25;horizalign,right;);
		  OnCommand=cmd(diffusealpha,0;addx,-10;smooth,0.2;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set";playcommand,"Transition";); 
		  TransitionCommand=cmd(finishtweening;diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
		  PlayerJoinedMessageCommand=cmd(playcommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self)
			stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP2 ~= nil then
					self:settext(stepsP2:GetMeter())
				else
					self:settext("")
				end
			else
				self:settext("")
			end
          end
};

-- Difficulty name
t[#t+1] = LoadFont("Common bold") .. { 
          InitCommand=cmd(x,SCREEN_LEFT+277;y,SCREEN_CENTER_Y-143;horizalign,left;);
		  OnCommand=cmd(diffusealpha,0;addx,-10;smooth,0.2;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set";playcommand,"Transition";); 
		  PlayerJoinedMessageCommand=cmd(playcommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set");
		  TransitionCommand=cmd(finishtweening;diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
          SetCommand=function(self)
			stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP1 ~= nil then
					self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString( stepsP1:GetDifficulty())));
				else
					self:settext("")
				end
			else
				self:settext("")
			end
          end
};

t[#t+1] = LoadFont("Common bold") .. { 
          InitCommand=cmd(x,SCREEN_LEFT+277;y,SCREEN_CENTER_Y-33;horizalign,left;); 
		  OnCommand=cmd(diffusealpha,0;addx,-10;smooth,0.2;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set";playcommand,"Transition";); 
		  PlayerJoinedMessageCommand=cmd(playcommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set");
		  TransitionCommand=cmd(finishtweening;diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
          SetCommand=function(self)
			stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP2 ~= nil then
					self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString( stepsP2:GetDifficulty())));
				else
					self:settext("")
				end
			else
				self:settext("")
			end
          end
};

t[#t+1] = LoadFont("_arimo Bold 24px") .. { 
		  InitCommand=cmd(x,SCREEN_LEFT+383;y,SCREEN_CENTER_Y+120;horizalign,left;zoom,0.8;diffuse,color("#212121");visible,not GAMESTATE:IsCourseMode();); 
		  OnCommand=cmd(diffusealpha,0;addx,-10;smooth,0.2;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          BeginCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
				self:settext("BPM");
          end;
};

t[#t+1] = StandardDecorationFromFileOptional("GrooveRadar","GrooveRadar");
t[#t+1] = StandardDecorationFromFileOptional("DifficultyList","DifficultyList");
t[#t+1] = StandardDecorationFromFileOptional("BPMDisplay","BPMDisplay");
t[#t+1] = StandardDecorationFromFileOptional("StageDisplay","StageDisplay");
t[#t+1] = StandardDecorationFromFileOptional("SongTime","SongTime") .. {
	SetCommand=function(self)
		local curSelection = nil;
		local length = 0.0;
		if GAMESTATE:IsCourseMode() then
			self:settext("");
		else
			curSelection = GAMESTATE:GetCurrentSong();
			self:playcommand("Reset");
			if curSelection then
				length = curSelection:MusicLengthSeconds();
				if curSelection:IsLong() then
					self:playcommand("Long");
				elseif curSelection:IsMarathon() then
					self:playcommand("Marathon");
				else
					self:playcommand("Reset");
				end
			else
				length = 0.0;
				self:playcommand("Reset");
			end;
			self:settext( SecondsToMSS(length) );
		end;
	end;
	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
	CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
};

return t